//#define TRACEDNS

using System;
using System.Net;
using System.Diagnostics;
using System.Collections;

namespace Team_Project
{
	/// <summary>
	/// Classe di comodo che gestisce staticamente indirizzi IP e porte di
	/// ascolto di alcune copie.
	/// </summary>
	public class MyDNS
	{
		/// <summary>
		/// Contiene gli IP delle varie copie come stringa.
		/// Come chiave viene utilizzato il nome della copia
		/// </summary>
		protected static Hashtable Hosts = new Hashtable();
		/// <summary>
		/// Contiene gli interi corrispondenti alla porta in cui  in ascolto il
		/// ProtocolManager delle varie copie.
		/// Come chiave  utilizzato il nome della copia.
		/// </summary>
		protected static Hashtable ListenerPorts = new Hashtable();
		/// <summary>
		/// Costruttore statico. Imposta tutti i dati
		/// </summary>
		static MyDNS()
		{
			Hosts.Add("SIMO","127.0.0.1");
			Hosts.Add("Ancestor","127.0.0.1");
			Hosts.Add("Mattia","127.0.0.1");
			Hosts.Add("Perugia","127.0.0.1");
			Hosts.Add("NodeR","127.0.0.1");
			Hosts.Add("Parent","127.0.0.1");
			Hosts.Add("PP1","127.0.0.1");
			Hosts.Add("PP2","127.0.0.1");

			ListenerPorts.Add("SIMO",7000);
			ListenerPorts.Add("Ancestor",7001);
			ListenerPorts.Add("Mattia",7002);
			ListenerPorts.Add("Perugia",7003);
			ListenerPorts.Add("NodeR",7004);
			ListenerPorts.Add("Parent",7005);
			ListenerPorts.Add("PP1",7006);
			ListenerPorts.Add("PP2",7007);
		}

		/// <summary>
		/// Restituisce la porta a cui  disponibile il protocol manager
		/// della copia richiesta
		/// </summary>
		/// <param name="Name">Nome della copia</param>
		/// <returns>Numero della porta</returns>
		public static int ListenerPort(string Name)
		{
#if TRACEDNS
			Trace.WriteLine("DNS: Resolving port of " + Name);
#endif
			return (int)ListenerPorts[Name];
		}
        
		/// <summary>
		/// Risolve l'indirizzo ip della copia richiesta restituendolo come stringa
		/// </summary>
		/// <param name="Name">Nome della copia richiesta</param>
		/// <returns>Una stringa rappresentante l'indirizzo ip</returns>
		public static string Resolve(string Name)
		{
#if TRACEDNS
			Trace.WriteLine("DNS: Resolving " + Name);
#endif
			return (string)Hosts[Name];
		}

		/// <summary>
		/// Risolve l'indirizzo ip della copia richiesta
		/// </summary>
		/// <remarks>Se il nome della copia  errato lancia un'eccezione</remarks>
		/// <param name="Name">Nome della copia richiesta</param>
		/// <returns>Indirizzo ip della copia</returns>
		public static IPAddress ResolveIP(string Name)
		{
			return IPAddress.Parse(Resolve(Name));
		}
	}
}
